#!/usr/bin/env python3

from pycolib import prettysize

import unittest


class TestPrettySize(unittest.TestCase):

    def test_prettysize(self):
        psize = prettysize.prettysize_short
        expected = (
            (0, '0'),
            (1000, '1000'),
            (1024, '1K'),
            (1050, '1.03K'),
            (2050, '2K'),
            (333333, '325.52K'),
            (1048576, '1M'),
            (1050000, '1M'),
            (5555555, '5.3M'),
            (1073741824, '1G'),
            )
        for value, result in expected:
            self.assertEqual(psize(value), result)


if __name__ == '__main__':
    unittest.main()
