#!/usr/bin/env python3

from pycolib.coloredformatter import ColoredFormatter

import logging


def prepare_logger(name, level=logging.DEBUG):
    logger = logging.getLogger(name)
    logger.setLevel(level)
    return logger


def prepare_console_handler(level=logging.DEBUG):
    handler = logging.StreamHandler()
    formatter = ColoredFormatter('%(asctime)s %(levelname)-5s %(message)s', '%H:%M:%S')
    formatter.set_color('message', 'RECV', 2)
    formatter.set_color('message', 'SEND', 6)
    handler.setFormatter(formatter)
    handler.setLevel(level)
    return handler


def setup():
    logging.addLevelName(21, 'RECV')
    logging.addLevelName(22, 'SEND')

    logger_main = prepare_logger('main')

    handler_console = prepare_console_handler()
    logger_main.addHandler(handler_console)


def finish():
    logging.shutdown()


def main():
    setup()
    log = logging.getLogger('main')

    log.info('test')

    try:
        raise Exception('test exception')
    except:
        log.exception('test exc')

    log.log(21, 'recv')
    log.log(22, 'send')

    log.debug('debug')

    finish()


if __name__ == '__main__':
    main()

