#!/usr/bin/env python3

from pycolib.configparser import ConfigParser, ConfigParserError

import unittest
import os.path


class TestConfigParser(unittest.TestCase):

    def setUp(self):
        self.config = ConfigParser()
        self.config.add_option('arg_str')
        self.config.add_option('arg_int', int, 1)
        script_path = os.path.dirname(os.path.realpath(__file__))
        self.data_path = os.path.join(script_path, 'data')

    def test_add_option(self):
        name = 'argname'
        self.config.add_option(name, int, 1)
        self.assertEqual(self.config.options[name]['type'], int)
        self.assertEqual(self.config.options[name]['default'], 1)
        self.assertEqual(self.config.values[name], 1)

    def test_load_badname(self):
        self.assertRaises(IOError, self.config.load, 'bad/file_name')

    def test_load_badargs(self):
        fname = os.path.join(self.data_path, 'test_badargs.conf')
        self.assertRaises(ConfigParserError, self.config.load, fname)

    def test_load_ok(self):
        fname = os.path.join(self.data_path, 'test_ok.conf')
        self.config.load(fname)
        self.assertEqual(self.config.arg_str, '1')
        self.assertEqual(self.config.arg_int, 2)


if __name__ == '__main__':
    unittest.main()
