# -*- coding: utf-8 -*-
#
# PgStats - browse database statistics
#
# Copyright (c) 2011  Radek Brich <radek.brich@devl.cz>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


class PgStats:
    def __init__(self, conn=None):
        self.conn = conn
        
    def setconn(self, conn=None):
        self.conn = conn

    def _query(self, query, *args):
        try:
            curs = self.conn.cursor()
            curs.execute(query, args)
            curs.connection.commit()
            rows = curs.fetchall()
            return [dict(zip([desc[0] for desc in curs.description], row)) for row in rows]
        finally:
            curs.close()

    def list_long_queries(self, longer_than='1m'):
        return self._query('''SELECT datname, procpid, usename, current_query AS query,
            waiting, xact_start, query_start, backend_start
            FROM pg_stat_activity
            WHERE current_query <> '<IDLE>' AND query_start < now() - interval %s
            ORDER BY query_start;''',
            longer_than)

