#!/usr/bin/env python3

import logging
import time

from tests.config import Config
from pydbkit import pgmanager
from pydbkit.delayedquery import DelayedQuery


if __name__ == '__main__':
    cfg = Config('tests.conf')

    pgm = pgmanager.get_instance()
    pgm.create_conn(isolation_level = 'autocommit', **cfg)

    handler = logging.StreamHandler()
    logger = logging.getLogger('pgmanager')
    logger.addHandler(handler)
    logger.setLevel(logging.DEBUG)

    dq = DelayedQuery(pgm)

    print('add 1')
    dq.add(10, 'INSERT INTO test (name) VALUES (%s)', ['spam1'], queryid=1)
    dq.add(10, 'INSERT INTO test (name) VALUES (%s)', ['spam1'], queryid=1)
    print('after 1')

    time.sleep(5)

    print('add 2')
    dq.add(10, 'INSERT INTO test (name) VALUES (%s)', ['spam2'])

    time.sleep(5)
    print('after 10')

    time.sleep(10)
