from pgtoolkit.toolbase import SimpleTool
from pgtoolkit import pgstats
from pycolib.ansicolor import highlight, YELLOW, BOLD


class LongQueriesTool(SimpleTool):

    """
    List long running queries.
    """

    def __init__(self):
        SimpleTool.__init__(self, name='longqueries')

    def specify_args(self):
        SimpleTool.specify_args(self)
        self.parser.add_argument('--age', default='1m', help='How long must be the query running to be listed.')

    def main(self):
        stats = pgstats.PgStats(self.pgm.get_conn('target'))

        for ln in stats.list_long_queries(self.args.age):
            print(highlight(1),
                  'backend PID: ', ln['procpid'],
                  ', query_start: ', ln['query_start'].strftime('%F %T'),
                  ', client IP: ', ln['client_addr'],
                  ln['waiting'] and ', ' + highlight(1, YELLOW|BOLD) + 'waiting' or '',
                  highlight(0), sep='')
            print(ln['query'])
            print()


cls = LongQueriesTool

