from pgtoolkit.toolbase import SrcDstTool
from pgtoolkit import pgmanager, pgbrowser, pgdiff, toolbase


class SchemaDiffTool(SrcDstTool):

    """
    Print differences in database schema.

    Prints changes from source to destination.
    SQL patch updates source database schema to destination schema.

    """

    def __init__(self):
        SrcDstTool.__init__(self, name='schemadiff', allow_reverse=True)

    def specify_args(self):
        SrcDstTool.specify_args(self)
        self.parser.add_argument('-s', dest='schema', nargs='*', help='Schema filter')
        self.parser.add_argument('-t', dest='table', nargs='*', help='Table filter')
        self.parser.add_argument('-f', dest='function', type=str, help='Function filter (regex)')
        self.parser.add_argument('--sql', action='store_true', help='Output is SQL script.')
        self.parser.add_argument('--body', action='store_true', help='Output diff for function bodies.')

    def main(self):
        srcbrowser = pgbrowser.PgBrowser(self.pgm.get_conn('src'))
        dstbrowser = pgbrowser.PgBrowser(self.pgm.get_conn('dst'))

        pgd = pgdiff.PgDiff(srcbrowser, dstbrowser)

        try:
            if self.args.schema:
                pgd.filter_schemas(include=self.args.schema)
            if self.args.table:
                pgd.filter_tables(include=self.args.table)
            if self.args.function:
                pgd.filter_functions(self.args.function)
            if self.args.body:
                pgd.function_body_diff = True

            if self.args.sql:
                pgd.print_patch()
            else:
                pgd.print_diff()
        except pgdiff.PgDiffError as e:
            print('PgDiff error:', str(e))


cls = SchemaDiffTool

