from pgtoolkit.toolbase import SimpleTool
from pgtoolkit import pgbrowser


class ListDependsTool(SimpleTool):

    """
    List column dependencies.

    """

    def __init__(self):
        SimpleTool.__init__(self, name='listdepends')

    def specify_args(self):
        SimpleTool.specify_args(self)
        self.parser.add_argument('table', metavar='table', type=str, help='Table name.')
        self.parser.add_argument('column', metavar='column', type=str, help='Column name.')
        self.parser.add_argument('-s', '--schema', dest='schema', metavar='schema',
            type=str, default='public', help='Schema name (default=public).')

    def main(self):
        browser = pgbrowser.PgBrowser(self.pgm.get_conn('target'))

        objects = browser.list_column_usage(self.args.table, self.args.column, schema=self.args.schema)
        for obj in sorted(objects, key=lambda x: (x['type'], x['schema'], x['name'])):
            print(obj['type'], ' ', obj['schema'], '.', obj['name'], sep='')


cls = ListDependsTool

