import logging


class ConfigParser:
    def __init__(self):
        self.args = {}       # config file arguments
        self.registered_args = {}
        self.log = logging.getLogger('config') 

    def add_argument(self, name, type=str, default=None):
        self.registered_args[name] = {'type':type, 'default':default}

    def load(self, fname):
        # parse config file
        with open(fname) as f:
            exec(f.read(), self.args)
        # check contents
        return self.check()

    def check(self):
        ok = True
        for key in self.args.keys():
            if key == '__builtins__':
                continue
            if key in self.registered_args:
                # arg registered, check type
                type = self.registered_args[key]['type']
                if not isinstance(self.args[key], type):
                    ok = False
                    self.log.error("Bad type of config parameter '%s': is %s but should be %s",
                        key, type(self.args[key]), type)
            else:
                # arg not registered
                    ok = False
                    self.log.error("Unknown config parameter '%s'.", key)
        return ok

    def __getattr__(self, name):
        if name in self.args:
            return self.args[name]

        # raise error if not found
        raise AttributeError()

