# -*- coding: utf-8 -*-

(BLACK, RED, GREEN, YELLOW, BLUE, MAGENTA, CYAN, WHITE, BOLD) = range(0,9)

names = ['black','red','green','yellow','blue','magenta','cyan','white']

disabled = False  # set True to disable all colors

def highlight(enable, fg=None, bg=None):
    '''

    highlight(1) -- switch to bold
    highlight(1,1) -- red foreground
    highlight(1,3,4) -- red on blue
    highlight(0) -- reset

    '''
    global disabled
    if disabled:
        return ''

    if enable:
        code = '1'
        if fg is not None:
            code = ''
            if fg >= 8:
                fg -= 8
                code += '1;'
            code += str(30 + fg)
        if bg is not None:
            code += ';'
            if bg >= 8:
                bg -= 8
                code += '1;'
            code += str(40 + bg)
        return "\033[" + code + "m"
    else:
        return "\033[0m"

def sethighlight(enable, fg=None, bg=None):
    print(highlight(enable, fg, bg), end='')


if __name__ == '__main__':
    for c in range(0,8):
        print(
            highlight(1,c), names[c].ljust(20),
            highlight(1,8+c), names[c].ljust(20),
            highlight(0), sep='')

