#!/usr/bin/env python3

from tests.config import Config
from mytoolkit import mymanager

import unittest


class TestMyManager(unittest.TestCase):

    def setUp(self):
        cfg = Config('pgtoolkit.conf')
        test_db_conn_params = cfg['databases']['test_mysql']
        params = self.params_to_mapping(test_db_conn_params)
        self.m = mymanager.get_instance()
        self.m.create_conn(**params)

    def tearDown(self):
        self.m.destroy_conn()

    def params_to_mapping(self, params):
        return dict([param.split('=') for param in params.split(' ')])

    def test_mysql_query(self):
        with self.m.cursor() as curs:
            ajaj = 1
            curs.execute('SELECT %(ajaj)s AS ajaj', locals())
            row = curs.fetchone_dict()
            self.assertEqual(row.ajaj, ajaj)


if __name__ == '__main__':
    unittest.main()

