#!/usr/bin/env python3

from tests.config import Config
from pydbkit import mymanager

import unittest
import logging


class TestMyManager(unittest.TestCase):

    def setUp(self):
        cfg = Config('pydbkit.conf')
        test_db_conn_params = cfg['databases']['test_mysql']
        params = self.params_to_mapping(test_db_conn_params)
        self.m = mymanager.get_instance()
        self.m.create_conn(**params)
        #self.setup_logging()

    def tearDown(self):
        self.m.destroy_conn()

    def setup_logging(self):
        #FIXME: write test handler, check SQL log
        log = logging.getLogger('mymanager_sql')
        handler = logging.StreamHandler()
        log.addHandler(handler)
        log.setLevel(logging.DEBUG)

    def params_to_mapping(self, params):
        return dict([param.split('=') for param in params.split(' ')])

    def test_mysql_query(self):
        with self.m.cursor() as curs:
            ajaj = 1
            curs.execute('SELECT %(ajaj)s AS ajaj', locals())
            row = curs.fetchone_dict()
            self.assertEqual(row.ajaj, ajaj)

    def test_mysql_error(self):
        with self.m.cursor() as curs:
            self.assertRaises(mymanager.OperationalError,
                curs.execute, 'SELECT give_me_some_error;')


if __name__ == '__main__':
    unittest.main()

