import threading
import time


class DelayedQueryThread(threading.Thread):
    def __init__(self, targetdbm, targetname, delay, query, args):
        threading.Thread.__init__(self)
        self.targetdbm = targetdbm
        self.targetname = targetname
        self.delay = delay
        self.query = query
        self.args = args
        
    def run(self):
        time.sleep(self.delay)
        with self.targetdbm.cursor(self.targetname) as curs:
            curs.execute(self.query, self.args)


class DelayedQuery:
    def __init__(self, targetdbm):
        '''Initialize DelayedQuery.
        
        targetdbm -- PgManager-like object
        
        '''
        self.targetdbm = targetdbm
        self.queryids = set()

    def add(self, delay, query, args, targetname='default', queryid=None):
        '''Add query to schedule.
        
        delay -- how long to wait, in seconds
        query, args -- query to be run after delay
        targetname -- name of connection in PgManager
        queryid -- discard if query with same id is already scheduled
        
        '''
        if queryid is not None:
            if queryid in self.queryids:
                return
            self.queryids.add(queryid)
        
        t = DelayedQueryThread(self.targetdbm, targetname, delay, query, args)
        t.start()

