#!/usr/bin/env python3

from pgtoolkit.pgmanager import RowDict

import unittest


class TestRowDict(unittest.TestCase):
    def setUp(self):
        self.rowdict = RowDict([('id', 123), ('name', 'hello')])

    def test_rowdict_as_kwargs(self):
        rowdict_id = (lambda **kwargs: kwargs['id']) (**self.rowdict)
        self.assertEqual(rowdict_id, 123)

    def test_rowdict_key_access(self):
        self.assertEqual(self.rowdict['id'], 123)

    def test_rowdict_attr_access(self):
        self.assertEqual(self.rowdict.name, 'hello')

    def test_rowdict_index_access(self):
        self.assertEqual(self.rowdict[0], 123)

    def test_rowdict_unpack(self):
        _id, name = self.rowdict
        self.assertEqual(name, 'hello')


if __name__ == '__main__':
    unittest.main()
