from gi.repository import Gtk


class PanedExt(Gtk.Paned):
    """Extended Gtk.Paned (abstract)

    set_snap1(int), set_snap2(int)
        set minimum size of child widget
        if the handle is moved to the edge, child widget is hidden
    """
    def __init__(self):
        self.connect('notify::position', self.on_position_change)
        self.min1 = 0
        self.min2 = 0


    def set_snap1(self, minpos):
        self.min1 = minpos


    def set_snap2(self, minpos):
        self.min2 = minpos


    def on_position_change(self, w, scrolltype):
        if self.get_allocation().width == -1:
            return False

        pos = self.get_position()
        maxpos = self.get_property('max-position')

        if self.min1:
            if pos > 0 and pos < self.min1:
                if pos < self.min1 / 2:
                    self.set_position(0)
                else:
                    self.set_position(self.min1)
                return True

        if self.min2:
           if pos > maxpos - self.min2 and pos < maxpos:
                if pos > maxpos - self.min2 / 2:
                    self.set_position(maxpos)
                else:
                    self.set_position(maxpos - self.min2)
                return True

        return False


class HPanedExt(Gtk.HPaned, PanedExt):
    def __init__(self):
        Gtk.HPaned.__init__(self)
        PanedExt.__init__(self)


class VPanedExt(Gtk.VPaned, PanedExt):
    def __init__(self):
        Gtk.VPaned.__init__(self)
        PanedExt.__init__(self)

