#!/usr/bin/python

from raytracer import Raytracer, Light, Sphere, Triangle, Material, Camera
from lworeader import LoadLightwaveLwoFile
import Image
from math import *

rt = Raytracer()

cam = Camera(eye=(0.,2.,8.))
rotx=0.15
cam.rotate((cos(rotx),-sin(rotx),0.,0.))
rt.setcamera(cam)

LoadLightwaveLwoFile(rt, "../models/lwo/Nissan300ZX.lwo", scale=0.4, trans=(-0.2,0,0.3))

light1 = Light(position=(-5.0, 20.0, 8.0), colour=(0.9, 0.9, 0.9))
rt.addlight(light1)
light2 = Light(position=(5.0, 10.0, 10.0), colour=(0.9, 0.7, 0.7))
rt.addlight(light2)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('car.png')
