/*
 * Pyrit Ray Tracer
 * file: octree.h
 *
 * Radek Brich, 2006-2007
 */

#ifndef OCTREE_H
#define OCTREE_H

#include "container.h"
#include "vector.h"
#include "scene.h"

#include <assert.h>

using namespace std;

class OctreeNode
{
    union {
		OctreeNode *children; // pointer to first of eight children
		ShapeList *shapes;    // pointer to shape array, if this is leaf
		off_t leaf;             // leaf indicator (bit 0)
	};
public:
	OctreeNode()
	{
		shapes = new ShapeList();
		assert(sizeof(off_t)==sizeof(void*) && !isLeaf());
		setLeaf();
	};
	~OctreeNode();

	bool isLeaf() { return leaf & 1; };
	void setLeaf() { leaf = leaf | 1; };

	void makeChildren() { children = new OctreeNode[8]; assert(!isLeaf()); }; // this also cleans leaf bit
	OctreeNode *getChild(const int num) { assert(!isLeaf()); return children + num; };

	void addShape(Shape* aShape) { getShapes()->push_back(aShape); };
	ShapeList *getShapes() { return (ShapeList*)((off_t)shapes & ~(off_t)1); };
	void setShapes(ShapeList *const ashapes) { shapes = ashapes; assert(!isLeaf()); setLeaf(); };

	void subdivide(BBox bbox, int maxdepth);
};

class Octree: public Container
{
	OctreeNode *root;
	bool built;
	int max_depth;
public:
	Octree() : Container(), root(NULL), built(false), max_depth(10) {};
	~Octree() { if (root) delete root; };
	void addShape(Shape* aShape) { Container::addShape(aShape); built = false; };
	Shape *nearest_intersection(const Shape *origin_shape, const Ray &ray,
		Float &nearest_distance);
	void optimize() { build(); };
	void build();
	void save(ostream &str, OctreeNode *node = NULL) {};
	void load(istream &str, OctreeNode *node = NULL) {};
	void setMaxDepth(int md) { max_depth = md; };
};

#endif
