#include "raytracer.h"
#include "image.h"

int main()
{
	Raytracer rt;
	rt.setThreads(1);

	Light light1(Vector3(0.0, 5.0, 5.0), Colour(0.7, 0.3, 0.6));
	rt.addlight(&light1);

	Light light2(Vector3(-2.0, 10.0, 2.0), Colour(0.4, 0.6, 0.3));
	rt.addlight(&light2);

	Material mat0(Colour(0.7, 0.7, 0.7));

	Box box(Vector3(-20.0, -1.2, -20.0), Vector3(20.0, -1.0, 20.0), &mat0);
	rt.addshape(&box);

	Material mat1(Colour(1.0, 0.0, 0.0));
	Sphere bigsphere(Vector3(3.0, 2.0, 7.0), 3.0, &mat1);
	rt.addshape(&bigsphere);

	Material mat2(Colour(0.0, 1.0, 0.0));
	Sphere smallsphere(Vector3(-5.5, 1.5, 8.0), 2.0, &mat2);
	rt.addshape(&smallsphere);

	Material mat3(Colour(0.0, 0.0, 1.0));
	Sphere tinysphere(Vector3(-1.2, 0.0, 2.0), 0.5, &mat3);
	rt.addshape(&tinysphere);

	int w = 800;
	int h = 600;
	float *fdata = rt.render(w, h);

	struct image *img;
	new_image(&img, w, h, 3);

	float *fd = fdata;
	for (char *cd = img->data; cd != img->data + w*h*3; cd++, fd++) {
		if (*fd > 1.0)
			*cd = 255;
		else
			*cd = (unsigned char)(*fd * 255.0);
	}
	free(fdata);
	save_png("spheres_shadow.png", img);
	destroy_image(&img);
}
