#!/usr/bin/python

from pyrit import *

rt = Raytracer()
rt.setBgColour((1.0,1.0,1.0))
top = Octree()
rt.setTop(top)

light1 = Light(position=(0.0, 5.0, -5.0), colour=(0.1, 0.3, 0.6))
light1.castShadows(False)
rt.addLight(light1)

light2 = Light(position=(-2.0, 10.0, -2.0), colour=(0.4, 0.6, 0.3))
light2.castShadows(False)
rt.addLight(light2)

mat = Material(colour=(0.7, 0.7, 0.7))
mat.setReflectivity(0.3)
mat.setTransmissivity(0.5, 1.5)
for x in range(8):
	for y in range(8):
		for z in range(8):
			box = Box(L=(-3.8+x, -3.8+y, -3.8+z), H=(-3.2+x, -3.2+y, -3.2+z), material=mat)
			rt.addShape(box)

top.optimize()

sampler = DefaultSampler(800, 600)
sampler.setOversample(1)
rt.setSampler(sampler)

rt.setCamera(Camera(eye=(-6,6,-10),lookat=(0,0,0)))
rt.render()
sampler.getPixmap().writePNG('boxes-1.png')

rt.setCamera(Camera(eye=(-4,3,-5),lookat=(0,0,0)))
rt.render()
sampler.getPixmap().writePNG('boxes-2.png')
