#!/usr/bin/python

from raytracer import Raytracer, Material, Box, Light
import Image

rt = Raytracer()

light1 = Light(position=(0.0, 5.0, -5.0), colour=(0.7, 0.3, 0.6))
rt.addlight(light1)

light2 = Light(position=(-2.0, 10.0, -2.0), colour=(0.4, 0.6, 0.3))
rt.addlight(light2)

mat0 = Material(colour=(0.7, 0.7, 0.7))
mat0.setReflectivity(0.0)
for x in range(8):
	for y in range(8):
		for z in range(8):
			box = Box(L=(-4.3+x, -4.6+y, -8.6+z), H=(-3.7+x, -4.0+y, -8.0+z), material=mat0)
			rt.addshape(box)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('boxes.png')
