#!/usr/bin/python

# this demo needs bunny model from
# http://graphics.stanford.edu/data/3Dscanrep/

import sys
sys.path.append(open('ModulePath').read().strip())

from raytracer import Raytracer, Light, Sphere, Triangle, NormalVertex, Material
from plyreader import LoadStanfordPlyFile
import Image

rt = Raytracer()
mat = Material(colour=(0.9, 0.9, 0.9))
LoadStanfordPlyFile(rt, "../models/bunny/bun_zipper.ply",
	mat, smooth=True, scale=(-29.0, 29.0, 29.0), trans=(-1,-3,-3))

light = Light(position=(-5.0, 2.0, 10.0), colour=(0.9, 0.3, 0.6))
rt.addlight(light)

light2 = Light(position=(4.0, -3.0, 10.0), colour=(0.2, 0.9, 0.5))
rt.addlight(light2)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('bunny.png')
