#!/usr/bin/python2.4

import sys
sys.path.append("../")

from raytracer import Raytracer, Light, Sphere, Triangle, Material
import Image

def LoadWavefrontObjFile(rt, mat, filename):
	vertices = []
	fp = file(filename)
	while True:
		ln = fp.readline()
		if ln == "":
			break;
		ln = ln.split()
		if ln[0] == "v":
			v = [1.5*float(x) for x in ln[1:4]]
			vertices.append(tuple(v))
		if ln[0] == "f":
			f = [vertices[int(x)-1] for x in ln[1:4]]
			face = Triangle(f[0], f[1], f[2], mat)
			rt.addshape(face)

rt = Raytracer()
mat = Material(colour=(0.9, 0.9, 0.9))
LoadWavefrontObjFile(rt, mat, "sphere.obj")

light1 = Light(position=(0.0, 2.0, -5.0), colour=(0.9, 0.3, 0.6))
light1.castshadows(False);
rt.addlight(light1)

light2 = Light(position=(-2.0, -5.0, -7.0), colour=(0.7, 1.0, 0.3))
light2.castshadows(False);
rt.addlight(light2)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('triangles_sphere.png')
