/*
 * C++ RayTracer
 * file: raytracer.h
 *
 * Radek Brich, 2006
 */

#ifndef RAYTRACER_H
#define RAYTRACER_H

#include <vector>

#include "scene.h"

using namespace std;

/* axis-aligned bounding box */
class AABB
{
};

class ShapeList: public vector<Shape*>
{
	AABB extends() { return AABB(); };
};

class Raytracer
{
	ShapeList shapes;
	vector<Light*> lights;
	Colour bg_colour;
	int ao_samples;
	float ao_distance, ao_angle;

	Vector3 SphereDistribute(int i, int n, float extent, Vector3 &normal);
	inline Shape *nearest_intersection(const Shape *origin_shape, const Ray &ray,
		float &nearest_distance);
	Colour raytrace(Ray &ray, int depth, Shape *origin_shape);
public:
	Raytracer(): shapes(), lights(), bg_colour(0.0, 0.0, 0.0), ao_samples(0) {};
	~Raytracer() {};
	float *render(int w, int h);
	void addshape(Shape *shape);
	void addlight(Light *light);

	void ambientocclusion(int samples, float distance, float angle);
};

#endif
