#!/usr/bin/python

# this demo needs buddha model from
# http://graphics.stanford.edu/data/3Dscanrep/

from pyrit import *
from plyreader import LoadStanfordPlyFile

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera())

light = Light(position=(-5.0, 2.0, 8.0), colour=(0.9, 0.3, 0.6))
rt.addLight(light)

mat = Material(colour=(0.9, 0.9, 0.9))
mat.setSmooth(True)
LoadStanfordPlyFile(rt, "../models/ply/happy/happy_vrip_res2.ply",
	mat, scale=20.0, trans=(0,-3,0))
top.optimize()

sampler = DefaultSampler(800, 600)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('buddha.png')
