/**
 * @file pixmap.h
 * @brief Pixmap class with PNG file format writer
 *
 * This file is part of Pyrit Ray Tracer.
 *
 * Copyright 2008  Radek Brich
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef PIXMAP_H
#define PIXMAP_H

#include "common.h"
#include "vector.h"

/**
 * 2D pixmap
 */
class Pixmap
{
	union
	{
		Colour *data;
		Float *fdata;
	};
	int w,h;
	bool refdata;
public:
	Pixmap(): data(NULL), w(0), h(0), refdata(true) {};
	Pixmap(Float *afdata, int aw, int ah):
		fdata(afdata), w(aw), h(ah), refdata(true) {};
	Pixmap(int aw, int ah):
		data(new Colour[aw*ah]), w(aw), h(ah), refdata(false) {};
	virtual ~Pixmap() { if (!refdata) delete[] data; };

	void setData(Float *afdata, int aw, int ah)
		{ fdata = afdata; w = aw; h = ah; };
	Colour get(int x, int y) { return data[y*w + x]; };
	const int &getWidth() const { return w; };
	const int &getHeight() const { return h; };
	Float*& getFloatData() { return fdata; };
	unsigned char *getCharData() const;
	int writePNG(const char *fname) const;
};

#endif
