#!/usr/bin/python

# this demo needs bunny model from
# http://graphics.stanford.edu/data/3Dscanrep/

from pyrit import *
from plyreader import LoadStanfordPlyFile

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera())

#rt.ambientocclusion(samples=100, distance=16.0, angle=0.5)

mat = Material(colour=(0.9, 0.9, 0.9))
mat.setTransmissivity(0.8)
mat.setSmooth(True)
LoadStanfordPlyFile(rt, "../models/ply/bunny/bun_zipper.ply",
	mat, scale=(-29.0, 29.0, 29.0), trans=(-1,-2.5,-3))

mat0 = Material(colour=(0.1, 0.2, 0.6))
box1 = Box(L=(-20.0, -1.7, -20.0), H=(20.0, -1.5, 20.0), material=mat0)
rt.addShape(box1)

mat1 = Material(colour=(0.5, 0.5, 0.2))
mat1.setReflectivity(0.0)
box2 = Box(L=(-20.0, -20.0, -10.0), H=(20.0, 20.0, -12.0), material=mat1)
rt.addShape(box2)

light = Light(position=(-5.0, 3.0, 10.0), colour=(0.8, 0.5, 0.6))
#light.castshadows(0)
rt.addLight(light)

light2 = Light(position=(4.0, 1.0, 10.0), colour=(0.5, 0.55, 0.7))
#light2.castshadows(0)
rt.addLight(light2)

top.optimize()

sampler = DefaultSampler(800, 600)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('bunny.png')
