#!/usr/bin/python

from raytracer import Raytracer, Material, Box, Sphere, Light
#, SphericalLight
import Image

rt = Raytracer()

light1 = Light(position=(0.0, 4.0, -3.0), colour=(0.9, 0.3, 0.6))
rt.addlight(light1)

#light2 = SphericalLight(position=(-2.0, 5.0, 1.0), radius=3.0, colour=(0.7, 1.0, 0.3))
light2 = Light(position=(-2.0, -4.0, -1.0), colour=(0.7, 1.0, 0.3))
rt.addlight(light2)

light2 = Light(position=(2.0, 5.0, 1.0), colour=(0.8, 0.9, 1.0))
rt.addlight(light2)

mat0 = Material(colour=(0.1, 0.2, 0.9))
box = Box(L=(-20.0, -2.2, -20.0), H=(20.0, -2.0, 20.0), material=mat0)
rt.addshape(box)

mat1 = Material(colour=(1.0, 0.2, 0.1))
mat1.setReflectivity(0.7)
bigsphere = Sphere(centre=(2.0, 1.0, -5.0), radius=2.5, material=mat1)
rt.addshape(bigsphere)

mat2 = Material(colour=(0.1, 0.4, 0.2))
mat2.setReflectivity(0.6)
smallsphere = Sphere(centre=(-4.5, 0.5, -8.0), radius=2.0, material=mat2)
rt.addshape(smallsphere)

mat3 = Material(colour=(0.9, 0.9, 1.0))
mat3.setPhong(0.2, 1.0, 0.2)
mat3.setTransmissivity(0.88)
mat3.setReflectivity(0.1)
for i in range(10):
	sph = Sphere(centre=(-5.0+i, -1.5, -4.0), radius=0.5, material=mat3)
	rt.addshape(sph)

rendersize = (800, 600)
data = rt.render(rendersize)
img = Image.fromstring("RGB", rendersize, data)
img.save('spheres_glass.png')
