#!/usr/bin/python

from pyrit import *
from lworeader import LoadLightwaveLwoFile
from plyreader import LoadStanfordPlyFile
from math import *
from time import time

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setBgColour((0.2,0.3,0.8))
cam = Camera(eye=(-8,3,4),lookat=(0,-0.5,1))
rt.setCamera(cam)

carmodel = "../models/lwo/Nissan300ZX.lwo"
bunnymodel = "../models/ply/bunny/bun_zipper.ply"

print "Loading file", carmodel
facenum = LoadLightwaveLwoFile(rt, carmodel, scale=0.4)
print "Loaded", facenum, "faces"

matbunny = Material(colour=(0.4, 0.5, 0.9))
matbunny.setTransmissivity(0.65, 1.3)
matbunny.setReflectivity(0.3)
matbunny.setSmooth(True)

print "Loading file", bunnymodel
facenum = LoadStanfordPlyFile(rt, bunnymodel,
	matbunny, scale=(20.0, 20.0, -20.0), trans=(-1,-1.8,3.5))
print "Loaded", facenum, "faces"

mat = Material(colour=(0.5, 0.5, 0.5))
ground = Box(L=(-10,-2,-10), H=(10,-1.2,10), material=mat)
rt.addShape(ground)

lwall = Box(L=(-10,-2,-4), H=(10,10,-3), material=mat)
rt.addShape(lwall)

mat = Material(colour=(0.5, 0.5, 0.5))
mat.setReflectivity(0.7)
backwall = Box(L=(8,-2, -10), H=(10,10,10), material=mat)
rt.addShape(backwall)

light1 = Light(position=(-5.0, 20.0, 8.0), colour=(0.9, 0.9, 0.9))
rt.addLight(light1)
light2 = Light(position=(5.0, 10.0, 10.0), colour=(0.9, 0.7, 0.7))
rt.addLight(light2)

t1 = time()
top.optimize()
t2 = time()
print "kd-tree built in", (t2-t1), "s"

sampler = DefaultSampler(1024, 768)
sampler.setOversample(1)
rt.setSampler(sampler)

t1 = time()
rt.render()
t2 = time()
print "rendered in", (t2-t1), "s"

sampler.getPixmap().writePNG('bench.png')
