#!/usr/bin/python

# Usage: render_nff.py [scene.nff] [output.png]
# reads scene from nff file and render it to PNG file
# if no output file name is given, it makes one from input name
# reads from stdin by default

# see http://tog.acm.org/resources/SPD/ for nff format description
# cylinders are currently not implemented

from pyrit import *
from math import pi
import sys

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera())

imagesize = (800, 600)

mat = Material(colour=(1.0, 1.0, 1.0))

f = sys.stdin
fout = "render_nff.png"
if len(sys.argv) > 1:
	f = open(sys.argv[1])
	fout = sys.argv[1].rsplit('.',1)[0] + '.png'
if len(sys.argv) > 2:
	fout = sys.argv[2]

while True:
	line = f.readline()
	if line == "":
		break;
	ln = line.split()
	if ln[0] == 'v':	# Viewpoint location
		# from
		ln = f.readline().split()
		assert ln[0] == 'from'
		eye = (float(ln[1]), float(ln[2]), float(ln[3]))
		# at
		ln = f.readline().split()
		assert ln[0] == 'at'
		lookat = (float(ln[1]), float(ln[2]), float(ln[3]))
		# up
		ln = f.readline().split()
		assert ln[0] == 'up'
		up = (float(ln[1]), float(ln[2]), float(ln[3]))
		# angle
		ln = f.readline().split()
		assert ln[0] == 'angle'
		angle = float(ln[1])
		# hither
		ln = f.readline().split()
		assert ln[0] == 'hither'
		hither = float(ln[1])
		# resolution
		ln = f.readline().split()
		assert ln[0] == 'resolution'
		imagesize = (int(ln[1]), int(ln[2]))
		# set camera as specified
		cam = Camera(eye=eye, lookat=lookat, up=up)
		cam.setAngle(angle/180*pi)
		rt.setCamera(cam)
	elif ln[0] == 'b':	# Background color
		rt.setBgColour((float(ln[1]), float(ln[2]), float(ln[3])))
	elif ln[0] == 'l':	# Light
		pos = (float(ln[1]), float(ln[2]), float(ln[3]))
		rt.addLight(Light(position=pos))
	elif ln[0] == 'f':	# Fill color and shading parameters
		colour = (float(ln[1]), float(ln[2]), float(ln[3]))
		mat = Material(colour=colour)
		mat.setPhong(0,float(ln[4]),float(ln[5]),float(ln[6]))
		mat.setTransmissivity(float(ln[7]),float(ln[8]))
	elif ln[0] == 's':	# Sphere
		center = (float(ln[1]), float(ln[2]), float(ln[3]))
		radius = float(ln[4])
		rt.addShape(Sphere(center=center, radius=radius, material=mat))
	elif ln[0] == 'p':	# Polygon
		vertex_count = int(ln[1])
		vertices = []
		for i in range(vertex_count):
			ln = f.readline().split()
			vertex = (float(ln[0]), float(ln[1]), float(ln[2]))
			vertices.append(NormalVertex(vertex))
		rt.addShape(Triangle(vertices[0], vertices[1], vertices[2], mat))
		for i in range(vertex_count)[3:]:
			rt.addShape(Triangle(vertices[0], vertices[i-1], vertices[i], mat))
	elif ln[0] == 'pp':	# Polygonal patch
		mat.setSmooth(True)
		vertex_count = int(ln[1])
		vertices = []
		for i in range(vertex_count):
			ln = f.readline().split()
			vertex = (float(ln[0]), float(ln[1]), float(ln[2]))
			normal = (float(ln[3]), float(ln[4]), float(ln[5]))
			vertices.append(NormalVertex(vertex, normal))
		rt.addShape(Triangle(vertices[0], vertices[1], vertices[2], mat))
		for i in range(vertex_count)[3:]:
			rt.addShape(Triangle(vertices[0], vertices[i-1], vertices[i], mat))
	elif ln[0] == '#':	# Comment
		pass
	else:
		print "Not implemented:", line
f.close()

top.optimize()

sampler = DefaultSampler(imagesize)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG(fout)
