/*
 * Pyrit Ray Tracer
 * file: octree.h
 *
 * Radek Brich, 2006-2007
 */

#ifndef OCTREE_H
#define OCTREE_H

#include "container.h"
#include "vector.h"
#include "scene.h"

using namespace std;

class OctreeNode
{
	OctreeNode *children; // pointer to first of eight children
public:
	ShapeList *shapes;    // pointer to shape array, if this is leaf

	OctreeNode() : children(NULL) { shapes = new ShapeList(); };
	~OctreeNode();

	bool isLeaf() { return shapes != NULL; };

	OctreeNode *getChild(const int num) { return children+num; };

	void addShape(Shape* aShape) { shapes->push_back(aShape); };

	void subdivide(BBox bbox, int maxdepth);
};

class Octree: public Container
{
	OctreeNode *root;
	bool built;
	int max_depth;
public:
	Octree() : Container(), root(NULL), built(false), max_depth(10) {};
	~Octree() { if (root) delete root; };
	void addShape(Shape* aShape) { Container::addShape(aShape); built = false; };
	Shape *nearest_intersection(const Shape *origin_shape, const Ray &ray,
		Float &nearest_distance);
	void optimize() { build(); };
	void build();
	void save(ostream &str, OctreeNode *node = NULL) {};
	void load(istream &str, OctreeNode *node = NULL) {};
	void setMaxDepth(int md) { max_depth = md; };
};

#endif
