#include "raytracer.h"
#include "kdtree.h"

#include "common_sdl.h"
#include "common_ply.h"

int main(int argc, char **argv)
{
	Raytracer rt;
	KdTree top;
	Camera cam;

	rt.setMaxDepth(0);
	rt.setTop(&top);

	Light light1(Vector(-5.0, 2.0, 8.0), Colour(0.9, 0.3, 0.6));
	light1.castShadows(false);
	rt.addLight(&light1);

	//Light light2(Vector(-2.0, 10.0, 2.0), Colour(0.4, 0.6, 0.3));
	//light2.castShadows(false);
	//rt.addLight(&light2);

	Material mat(Colour(0.9, 0.9, 0.9));
	mat.setSmooth(true);
	load_ply(rt, "../models/ply/bunny/bun_zipper.ply", &mat, Vector(-29,29,29), Vector(-1,-3,0));

	rt.setCamera(&cam);
	cam.setEye(Vector(0,0,10));

	top.optimize();

	loop_sdl(rt, cam);
	
	return 0;
}
