#!/usr/bin/python

# this demo needs dragon model from
# http://graphics.stanford.edu/data/3Dscanrep/

from pyrit import *
from plyreader import LoadStanfordPlyFile

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera())

mat = Material(colour=(0.9, 0.9, 0.9))
mat.setSmooth(True)
LoadStanfordPlyFile(rt, "../models/ply/dragon/dragon_vrip_res2.ply",
	mat, scale=(-29.0, 29.0, -29.0), trans=(0.0, -3.6, 0.0))

light1 = Light(position=(-5.0, 2.0, 8.0), colour=(0.9, 0.3, 0.2))
rt.addLight(light1)

light2 = Light(position=(3.0, 0.0, 9.0), colour=(0.0, 1.0, 0.2))
rt.addLight(light2)

top.optimize()

sampler = DefaultSampler(800, 600)
sampler.setOversample(1)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('dragon.png')
