#!/usr/bin/python

import sys
sys.path.append(open('ModulePath').read().strip())

from raytracer import Raytracer, Light, Sphere, Triangle, Material, Camera
from lworeader import LoadLightwaveLwoFile
import Image
from math import *

rt = Raytracer()

cam = Camera(eye=(0.,5.,8.))
rotx=0.3
cam.rotate((cos(rotx),-sin(rotx),0.,0.))
rt.setcamera(cam)

mat = Material(colour=(0.9, 0.9, 0.9))
LoadLightwaveLwoFile(rt, "../models/car/Nissan300ZX.lwo", mat, smooth=False, scale=0.4)

light = Light(position=(-5.0, 2.0, 8.0), colour=(0.7, 0.7, 0.7))
rt.addlight(light)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('car.png')
