/*
 * container.cc: Container class
 *
 * This file is part of Pyrit Ray Tracer.
 *
 * Copyright 2007  Radek Brich
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "common.h"
#include "container.h"

void Container::addShape(Shape* aShape)
{
	shapes.push_back(aShape);
	if (shapes.size() == 0) {
		/* initialize bounding box */
		bbox = aShape->get_bbox();
		Vector3 eps(Eps,Eps,Eps);
		bbox = BBox(bbox.L - eps, bbox.H + eps);
	} else {
		/* adjust bounding box */
		BBox shapebb = aShape->get_bbox();
		if (shapebb.L.x - Eps < bbox.L.x)  bbox.L.x = shapebb.L.x - Eps;
		if (shapebb.L.y - Eps < bbox.L.y)  bbox.L.y = shapebb.L.y - Eps;
		if (shapebb.L.z - Eps < bbox.L.z)  bbox.L.z = shapebb.L.z - Eps;
		if (shapebb.H.x + Eps > bbox.H.x)  bbox.H.x = shapebb.H.x + Eps;
		if (shapebb.H.y + Eps > bbox.H.y)  bbox.H.y = shapebb.H.y + Eps;
		if (shapebb.H.z + Eps > bbox.H.z)  bbox.H.z = shapebb.H.z + Eps;
	}
};

Shape *Container::nearest_intersection(const Shape *origin_shape, const Ray &ray,
        Float &nearest_distance)
{
	Shape *nearest_shape = NULL;
	ShapeList::iterator shape;
	for (shape = shapes.begin(); shape != shapes.end(); shape++)
		if (*shape != origin_shape && (*shape)->intersect(ray, nearest_distance))
			nearest_shape = *shape;
	return nearest_shape;
}
