#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <stdarg.h>
#include <float.h>

#ifdef PYRIT_DOUBLE
# define Float double
# define Eps DBL_EPSILON
# define Inf DBL_MAX
#else
# define Float float
# define Eps 1e-6
# define Inf FLT_MAX
#endif

/* verbosity level:
0: only errors (E)
1: major status messages (*)
2: minor status, progress (-)
3: debug messages (D)
4: more debug
default = 2
*/
extern int pyrit_verbosity;

inline void dbgmsg(const int vlevel, const char *format, ...)
{
	if (pyrit_verbosity >= vlevel)
	{
		va_list ap;
		va_start(ap, format);
		vprintf(format, ap);
		va_end(ap);
		fflush(stdout);
	}
}

#endif
