#ifndef COMMON_H
#define COMMON_H

#include <stdio.h>
#include <stdarg.h>
#include <float.h>

#ifdef PYRIT_DOUBLE
# define Float double
# define Eps DBL_EPSILON
# define Inf DBL_MAX
#else
# define Float float
# define Eps 1e-6
# define Inf FLT_MAX
#endif

inline void infomsg(const char *format, ...)
{
#ifndef PYRIT_QUIET
	va_list ap;
	va_start(ap, format);
	vprintf(format, ap);
	va_end(ap);
#endif
}

#endif
