#!/usr/bin/python

from raytracer import Raytracer, Light, Sphere, Triangle, NormalVertex, Material
from objreader import LoadWavefrontObjFile
import Image

rt = Raytracer()
mat = Material(colour=(0.9, 0.9, 0.9))
LoadWavefrontObjFile(rt, "../models/obj/sphere.obj", mat, 1.5)

light1 = Light(position=(0.0, 2.0, 6.0), colour=(0.9, 0.3, 0.6))
light1.castShadows(False);
rt.addLight(light1)

light2 = Light(position=(-2.0, -5.0, 7.0), colour=(0.7, 1.0, 0.3))
light2.castShadows(False);
rt.addLight(light2)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('triangles_sphere.png')
