#include "raytracer.h"
#include "octree.h"

#include "image.h"
#include "common_sdl.h"

Camera cam;
Light light(Vector3(-2.0, 10.0, -2.0), Colour(0.9, 0.9, 0.9));

Float lx, ly, lz, cf;

void update_callback(Float*)
{
	if (lx != 0.0)
		light.pos.x += lx;
	if (ly != 0.0)
		light.pos.y += ly;
	if (lz != 0.0)
		light.pos.z += lz;
	if (cf != 0.0)
		cam.F += cf;
}

void key_callback(int key, int down)
{
	switch (key)
	{
		case SDLK_r:
			lx = -0.1 * down;
			break;
		case SDLK_t:
			lx = +0.1 * down;
			break;
		case SDLK_f:
			ly = -0.1 * down;
			break;
		case SDLK_g:
			ly = +0.1 * down;
			break;
		case SDLK_v:
			lz = -0.1 * down;
			break;
		case SDLK_b:
			lz = +0.1 * down;
			break;

		case SDLK_z:
			cf = -0.02 * down;
			break;
		case SDLK_x:
			cf = +0.02 * down;
			break;
	}
}

int main(int argc, char **argv)
{
	Raytracer rt;

	Octree top;
	rt.setTop(&top);

	rt.addLight(&light);

	//Light light2;
	//light2.colour = Colour(0.7, 0.3, 0.6);
	//rt.addLight(&light2);

	Material mat0a(Colour(0.7, 0.7, 0.7));
	mat0a. setReflectivity(0.0);
	Box box(Vector3(-10.0, -1.2, -20.0), Vector3(10.0, -1.0, 0.0), &mat0a);
	rt.addShape(&box);

	Material mat0b(Colour(0.1, 0.7, 0.8));
	mat0b.setReflectivity(0.7);
	Box box2(Vector3(-10.0, -1.2, -20.0), Vector3(10.0, 10.0, -20.2), &mat0b);
	rt.addShape(&box2);

	Material mat1(Colour(1.0, 0.0, 0.0));
	Sphere bigsphere(Vector3(3.0, 2.0, -7.0), 3.0, &mat1);
	rt.addShape(&bigsphere);

	Material mat2(Colour(0.0, 1.0, 0.0));
	Sphere smallsphere(Vector3(-5.5, 1.5, -8.0), 2.0, &mat2);
	rt.addShape(&smallsphere);

	Material mat3(Colour(0.0, 0.0, 1.0));
	mat3.setReflectivity(0.1);
	mat3.setTransmissivity(0.8, 1.5);
	Sphere tinysphere(Vector3(-1.2, 0.0, -2.0), 0.7, &mat3);
	rt.addShape(&tinysphere);

	top.optimize();

	cam.setEye(Vector3(-2.28908, 4.30992, 12.3051));
	cam.p = Vector3(0.0988566, -0.139543, -0.985269);
	cam.u = Vector3(-0.995004, 0, -0.0998334);
	cam.v = Vector3(0.0139311, 0.990216, -0.138846);
	rt.setCamera(&cam);

	w = 800;
	h = 600;

	/* run interactive mode */
	loop_sdl(rt, cam, update_callback, key_callback);

	/* render image */
	if (argc == 2 && !strcmp(argv[1], "-r"))
	{
		pyrit_verbosity = 2;
		Float *fdata = (Float *) malloc(w*h*3*sizeof(Float));
		DefaultSampler sampler(fdata, w, h);
		sampler.setOversample(2);
		rt.setSampler(&sampler);
		rt.render();

		struct image *img;
		new_image(&img, w, h, 3);

		Float *fd = fdata;
		for (unsigned char *cd = img->data; cd != img->data + w*h*3; cd++, fd++) {
			if (*fd > 1.0)
				*cd = 255;
			else
				*cd = (unsigned char)(*fd * 255.0);
		}
		free(fdata);
		save_png("spheres_shadow.png", img);
		destroy_image(&img);
	}
}
