/*
 * serialize.cc: object serialization functions
 *
 * This file is part of Pyrit Ray Tracer.
 *
 * Copyright 2008  Radek Brich
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "serialize.h"
#include <string>
#include <sstream>

Indexer vertex_index, shape_index;

void resetSerializer()
{
	vertex_index.reset();
	shape_index.reset();
}

bool Indexer::get(void *o, int &retidx)
{
	map <void *, int>::iterator i;
	i = indexmap.find(o);
	if (i == indexmap.end())
	{
		retidx = index++;
		indexmap[o] = retidx;
		return false;
	}
	else
	{
		retidx = i->second;
		return true;
	}
}

Shape *loadShape(istream &st)
{
	string s;
	istringstream is;
	getline(st, s, ',');
	trim(s);
	if (s.compare("(box") == 0)
	{
		Vector3 L,H;
		st >> L;
		getline(st, s, ',');
		st >> H;
		getline(st, s, ')');
		return new Box(L, H, new Material(Colour(1,1,1)));
	}
	if (s.compare("(sphere") == 0)
	{
		Vector3 center;
		Float radius;
		st >> center;
		getline(st, s, ',');
		st >> radius;
		getline(st, s, ')');
		return new Sphere(center, radius, new Material(Colour(1,1,1)));
	}
	return NULL;
}

ostream & operator<<(ostream &st, Shape &o)
{
	return o.dump(st);
}

ostream & operator<<(ostream &st, Vertex &o)
{
	return o.dump(st);
}

ostream & operator<<(ostream &st, Container &o)
{
	return o.dump(st);
}
