#include "raytracer.h"
#include "octree.h"

#include "common_sdl.h"

Camera cam;
Light light(Vector(-2.0f, 10.0f, -2.0f), Colour(0.9f, 0.9f, 0.9f));

Float lx, ly, lz, cf;

void update_callback(Float*)
{
	if (lx != 0.0f)
		light.pos.x += lx;
	if (ly != 0.0f)
		light.pos.y += ly;
	if (lz != 0.0f)
		light.pos.z += lz;
	if (cf != 0.0f)
		cam.setF(cam.getF() + cf);
}

void key_callback(int key, int down)
{
	switch (key)
	{
		case SDLK_r:
			lx = -0.1f * down;
			break;
		case SDLK_t:
			lx = +0.1f * down;
			break;
		case SDLK_f:
			ly = -0.1f * down;
			break;
		case SDLK_g:
			ly = +0.1f * down;
			break;
		case SDLK_v:
			lz = -0.1f * down;
			break;
		case SDLK_b:
			lz = +0.1f * down;
			break;

		case SDLK_z:
			cf = -0.02f * down;
			break;
		case SDLK_x:
			cf = +0.02f * down;
			break;
	}
}

int main(int argc, char **argv)
{
	Raytracer rt;

	Octree top;
	rt.setTop(&top);

	rt.addLight(&light);

	//Light light2;
	//light2.colour = Colour(0.7, 0.3, 0.6);
	//rt.addLight(&light2);

	Material mat0a(Colour(0.7, 0.7, 0.7));
	mat0a. setReflectivity(0.0);
	Box box(Vector(-10.0, -1.2, -20.0), Vector(10.0, -1.0, 0.0), &mat0a);
	rt.addShape(&box);

	Material mat0b(Colour(0.1, 0.7, 0.8));
	mat0b.setReflectivity(0.7);
	Box box2(Vector(-10.0, -1.2, -20.0), Vector(10.0, 10.0, -20.2), &mat0b);
	rt.addShape(&box2);

	Material mat1(Colour(1.0, 0.0, 0.0));
	Sphere bigsphere(Vector(3.0, 2.0, -7.0), 3.0, &mat1);
	rt.addShape(&bigsphere);

	Material mat2(Colour(0.0, 1.0, 0.0));
	Sphere smallsphere(Vector(-5.5, 1.5, -8.0), 2.0, &mat2);
	rt.addShape(&smallsphere);

	Material mat3(Colour(0.0, 0.0, 1.0));
	mat3.setReflectivity(0.1);
	mat3.setTransmissivity(0.8, 1.5);
	Sphere tinysphere(Vector(-1.2, 0.0, -2.0), 0.7, &mat3);
	rt.addShape(&tinysphere);

	top.optimize();

	cam.setEye(Vector(-2.28908f, 4.30992f, 12.3051f));
	cam.setp(Vector(0.0988566f, -0.139543f, -0.985269f));
	cam.setu(Vector(-0.995004f, 0.0f, -0.0998334f));
	cam.setv(Vector(0.0139311f, 0.990216f, -0.138846f));
	rt.setCamera(&cam);

	w = 800;
	h = 600;

	/* run interactive mode */
	loop_sdl(rt, cam, update_callback, key_callback);

	/* render image */
	if (argc == 2 && !strcmp(argv[1], "-r"))
	{
		pyrit_verbosity = 2;
		DefaultSampler sampler(w, h);
		sampler.setOversample(2);
		rt.setSampler(&sampler);
		rt.render();
		sampler.getPixmap().writePNG("spheres_shadow.png");
	}

	return 0;
}
