#include <stdlib.h>

#include "raytracer.h"
#include "kdtree.h"

#include "common_sdl.h"

int main(int argc, char **argv)
{
	Raytracer rt;
	KdTree top;
	Camera cam;

	rt.setMaxDepth(3);
	rt.setTop(&top);

	Light light1(Vector(2.0f, -5.0f, -5.0f), Colour(0.7f, 0.3f, 0.6f));
	light1.castShadows(false);
	rt.addLight(&light1);

	Light light2(Vector(-2.0f, 10.0f, 2.0f), Colour(0.4f, 0.6f, 0.3f));
	light2.castShadows(false);
	rt.addLight(&light2);

	Material mat_sph(Colour(1.0f, 1.0f, 1.0f));
	for (int y=0; y<10; y++)
		for (int x=0; x<10; x++)
			rt.addShape(new Sphere(Vector(x*2-10, (Float)rand()/RAND_MAX*5.0f, y*2-10), 0.45f, &mat_sph));

	rt.setCamera(&cam);
	cam.setEye(Vector(0,0,10));

	top.optimize();

	loop_sdl(rt, cam);

	return 0;
}
