/*
 * container.h: Container class
 *
 * This file is part of Pyrit Ray Tracer.
 *
 * Copyright 2007, 2008  Radek Brich
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef CONTAINER_H
#define CONTAINER_H

#include <vector>

#include "shapes.h"

using namespace std;

/**
 * general container
 */
class Container
{
protected:
	BBox bbox;
public:
	ShapeList shapes;

	Container(): bbox(), shapes() {};
	virtual ~Container() {};

	virtual void addShape(Shape* aShape);
	//void addShapeNoExtend(Shape* aShape) { shapes.push_back(aShape); };
	virtual Shape *nearest_intersection(const Shape *origin_shape, const Ray &ray,
		Float &nearest_distance);

	virtual void optimize() {};

	ShapeList & getShapes() { return shapes; };

	virtual ostream & dump(ostream &st);

#ifndef NO_SIMD
	virtual void packet_intersection(const Shape* const* origin_shapes, const RayPacket &rays,
		Float *nearest_distances, Shape** nearest_shapes);
#endif
};

#endif
