#include <stdlib.h>

#include "raytracer.h"
#include "kdtree.h"

#include "common_sdl.h"

int main(int argc, char **argv)
{
	Raytracer rt;
	KdTree top;
	Camera cam;

	rt.setMaxDepth(3);
	rt.setTop(&top);

	Light light1(Vector(2.0, -5.0, -5.0), Colour(0.7, 0.3, 0.6));
	light1.castShadows(false);
	rt.addLight(&light1);

	Light light2(Vector(-2.0, 10.0, 2.0), Colour(0.4, 0.6, 0.3));
	light2.castShadows(false);
	rt.addLight(&light2);

	Material mat_sph(Colour(1.0, 1.0, 1.0));
	for (int y=0; y<10; y++)
		for (int x=0; x<10; x++)
			rt.addShape(new Sphere(Vector(x*2-10, (Float)rand()/RAND_MAX*5.0, y*2-10), 0.45, &mat_sph));

	rt.setCamera(&cam);
	cam.setEye(Vector(0,0,10));

	top.optimize();

	loop_sdl(rt, cam);
}
