#!/usr/bin/python

from pyrit import *
from objreader import LoadWavefrontObjFile

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera())

light = Light(position=(-5.0, 2.0, 8.0), colour=(0.9, 0.3, 0.6))
rt.addLight(light)

mat = Material(colour=(0.9, 0.9, 0.9))
LoadWavefrontObjFile(rt, "../models/obj/monkey.obj", mat, 1.5)
top.optimize()

sampler = DefaultSampler(800, 600)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('triangles_monkey.png')
