#!/usr/bin/python

from pyrit import *
from lworeader import LoadLightwaveLwoFile
from math import *

rt = Raytracer()
top = KdTree()
rt.setTop(top)
cam = Camera(eye=(0.,2.,8.))
rotx=0.15
cam.rotate((cos(rotx),-sin(rotx),0.,0.))
rt.setCamera(cam)

LoadLightwaveLwoFile(rt, "../models/lwo/Nissan300ZX.lwo", scale=0.4, trans=(-0.2,0,0.3))

light1 = Light(position=(-5.0, 20.0, 8.0), colour=(0.9, 0.9, 0.9))
rt.addLight(light1)
light2 = Light(position=(5.0, 10.0, 10.0), colour=(0.9, 0.7, 0.7))
rt.addLight(light2)

top.optimize()

sampler = DefaultSampler(800, 600)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('car.png')
