# Wavefron .obj file loader

from raytracer import Triangle, NormalVertex

def LoadWavefrontObjFile(rt, filename, mat, scale):
	vertices = []
	fp = file(filename)
	while True:
		ln = fp.readline()
		if ln == "":
			break;
		ln = ln.split()
		if ln[0] == "v":
			v = [scale*float(x) for x in ln[1:4]]
			vertices.append(tuple(v))
		if ln[0] == "f":
			f = [vertices[int(x)-1] for x in ln[1:4]]
			face = Triangle(NormalVertex(f[0]), NormalVertex(f[1]), NormalVertex(f[2]), mat)
			rt.addShape(face)
