/**
 * @file  matrix.h
 * @brief Matrix class, currently not used
 *
 * This file is part of Pyrit Ray Tracer.
 *
 * Copyright 2006, 2007, 2008  Radek Brich
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MATRIX_H
#define MATRIX_H

#include "vector.h"

using namespace std;

/**
 * matrix helper class
 */
class Matrix
{
public:
	Float data[4][4];

	Matrix(): {};

	// sum
	friend Matrix operator+(const Matrix &a, const Matrix &b)
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] = a.data[i][j] + b.data[i][j];
		return m;
	}

	// difference
	friend Matrix operator-(const Matrix &a, const Matrix &b)
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] = a.data[i][j] - b.data[i][j];
		return m;
	}

	// product
	friend Matrix operator*(const Matrix &a, const Matrix &b)
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] =
					a.data[i][0] * b.data[0][j] +
					a.data[i][1] * b.data[1][j] +
					a.data[i][2] * b.data[2][j] +
					a.data[i][3] * b.data[3][j];
		return m;
	}

	// negative
	Matrix operator-()
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] = -data[i][j];
		return m;
	}

	// product of matrix and scalar
	Matrix operator*(const Float &f)
	{
		Matrix m = Matrix();
		for (int i = 0; i < 4; i++)
			for (int j = 0; j < 4; j++)
				m.data[i][j] = data[i][j] * f;
		return m;
	}

	friend Matrix operator*(const Float &f, Matrix &m) { return m * f; };

	// product of matrix and vector
	Vector operator*(const Vector &v)
	{
		Vector u = Vector();
		u.x = data[0][0] * v.x + data[0][1] * v.y + data[0][2] * v.z + data[0][3] * v.w;
		u.y = data[1][0] * v.x + data[1][1] * v.y + data[1][2] * v.z + data[1][3] * v.w;
		u.z = data[2][0] * v.x + data[2][1] * v.y + data[2][2] * v.z + data[2][3] * v.w;
		u.w = data[3][0] * v.x + data[3][1] * v.y + data[3][2] * v.z + data[3][3] * v.w;
		return u;
	}

	friend Matrix operator*(const Vector &v, Matrix &m) { return m * v; };
};

#endif
