#!/usr/bin/python

from pyrit import *

rt = Raytracer()
top = KdTree()
rt.setTop(top)
rt.setCamera(Camera(eye=(0,1,6)))
rt.ambientOcclusion(samples=100, distance=16.0, angle=0.5)

light1 = Light(position=(0.0, 5.0, -5.0), colour=(0.7, 0.3, 0.6))
light1.castShadows(False)
rt.addLight(light1)

light2 = Light(position=(-2.0, 10.0, -2.0), colour=(0.4, 0.6, 0.3))
light2.castShadows(False)
rt.addLight(light2)

mat0 = Material(colour=(0.7, 0.7, 0.7))
box = Box(L=(-20.0, -1.2, -20.0), H=(20.0, -1.0, 20.0), material=mat0)
rt.addShape(box)

mat1 = Material(colour=(1.0, 0.0, 0.0))
bigsphere = Sphere(center=(3.0, 2.0, -7.0), radius=3.0, material=mat1)
rt.addShape(bigsphere)

mat2 = Material(colour=(0.0, 1.0, 0.0))
smallsphere = Sphere(center=(-5.5, 1.5, -8.0), radius=2.0, material=mat2)
rt.addShape(smallsphere)

mat3 = Material(colour=(0.0, 0.0, 1.0))
tinysphere = Sphere(center=(-1.2, 0.0, -2.0), radius=0.5, material=mat3)
rt.addShape(tinysphere)

top.optimize()

sampler = DefaultSampler(800, 600)
rt.setSampler(sampler)
rt.render()
sampler.getPixmap().writePNG('spheres_ao.png')
