#!/usr/bin/python

# this demo needs buddha model from
# http://graphics.stanford.edu/data/3Dscanrep/

import sys
sys.path.append("..")

from raytracer import Raytracer, Light, Sphere, Triangle, Material
import Image

def LoadStanfordPlyFile(rt, mat, filename, scale):
	vertices = []
	fp = file(filename)
	# read header
	tokens = (0,)
	while (tokens[0] != "end_header"):
		tokens = fp.readline().split()
		if (tokens[0] == "element"):
			if (tokens[1] == "vertex"):
				vertex_num = int(tokens[2])
			if (tokens[1] == "face"):
				face_num = int(tokens[2])

	# read vertices
	while (vertex_num):
		tokens = fp.readline().split()
		v = [scale*float(x) for x in tokens[0:3]]
		v[0] = -v[0]
		v[1] = v[1]-5
		v[2] = -v[2]
		vertices.append(tuple(v))
		vertex_num -= 1

	# read faces
	while (face_num):
		tokens = fp.readline().split()
		if (tokens[0] != "3"):
			print "ply warning: faces of %d vertices not supported" % tokens[0]
		f = [vertices[int(x)] for x in tokens[1:4]]
		face = Triangle(f[0], f[1], f[2], mat)
		rt.addshape(face)
		face_num -= 1

rt = Raytracer()
mat = Material(colour=(0.9, 0.9, 0.9))
LoadStanfordPlyFile(rt, mat, "happy_vrip_res2.ply", 30.0)

light = Light(position=(-5.0, 2.0, -8.0), colour=(0.9, 0.3, 0.6))
rt.addlight(light)

imagesize = (800, 600)
data = rt.render(imagesize)
img = Image.fromstring("RGB", imagesize, data)
img.save('buddha.png')
