/*
 * scene.cc: screen sample generation and image reconstruction
 *
 * This file is part of Pyrit Ray Tracer.
 *
 * Copyright 2008  Radek Brich
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <math.h>

#include "common.h"
#include "scene.h"

void DefaultSampler::init()
{
	phase = 0;
}

int DefaultSampler::initSampleSet()
{
	if ( phase == 0 )
	{
		phase++;
		return w*h;
	}
	else
	{
		phase = -1;
		return 0;
	}
}

Sample* DefaultSampler::nextSample(Sample *prev)
{
	DefaultSample *s = new DefaultSample;
	if (prev)
	{
		DefaultSample *sp = static_cast<DefaultSample*>(prev);
		s->sx = sp->sx + 1;
		s->sy = sp->sy;
		if (s->sx >= w)
		{
			s->sx = 0;
			s->sy++;
		}
		if (s->sy >= h)
		{
			delete s;
			return NULL;
		}
		s->x = (Float)s->sx/h - (Float)w/h/2.0;
		s->y = (Float)s->sy/h - 0.5;
	}
	else
	{
		s->x = -(Float)w/h/2.0;
		s->y = -0.5;
		s->sx = 0;
		s->sy = 0;
	}
	return s;
}

void DefaultSampler::saveSample(Sample *samp, Colour &col)
{
	DefaultSample *sp = static_cast<DefaultSample*>(samp);
	Float *buf = buffer + 3*(sp->sy*w + sp->sx);
	*(buf++) = col.r;
	*(buf++) = col.g;
	*(buf++) = col.b;
}

